/* -*-C-*-
 *#############################################################################
 *
 * File:        e1430/src/sicl_e.c
 * RCS:         "@(#)$Revision: 1.1 $ $Date: 94/03/15 17:05:30 $"
 * Description: SICL Emulation code
 * Created:     
 * Language:    C
 * Package:     E1430
 * Status:      "@(#)$State: Exp $"
 *
 * (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 *
 *#############################################################################
 *
 * This file contains code for emulating the Standard Instrument 
 * Control Library (SICL) functions.  It is used when porting code
 * written for SICL to a platform which does not support SICL.
 *
 * Some SICL functions are macros, see sicl_e.h.
 *
 * Only a small subset of the sicl functions are emulated.
 * 
 * If RADISYS is defined, this code will map sicl functions to Bus Manager
 * functions for the RadiSys EPC computers.  This is an example and should
 * not be needed since RasiSys supports SICL directly.  The RadiSys code
 * assumes no other processes are modifying VXI bus mapping.
 *
 *#############################################################################
*/


#include "machType.h"
#include <string.h>

#include "sicl_e.h"

#ifdef RADISYS 
#  include <busmgr.h>
#endif


#ifdef EMULATE_SICL	/* this code is only compiled when emulating SICL */

/**********************************************
* iopen() and iclose() create and terminate
* a SICL session.   Addr specifies the 
* interface, like "vxi".
********************************************/

INST iopen(char *addr)
{
    if (0 == strcmp( addr, "vxi" ))
	return 1;
    else
	return 0;
}



int iclose(INST id)
{
	return 0;
}


/**********************************************
* iwpeek(), iwpoke()  read and write 16-bit
* words.  They are handled as macros in sicl_e.h
**********************************************/



/**********************************************
* imap() maps a memory space the user' 
* process space.  In this case it returns 
* a pointer to the beginning of VXI memory.
**********************************************/

char * imap(INST id, int mapspace, unsigned int pagestart, 
	unsigned int pagecnt, char *suggested)
{

#ifdef RADISYS 
    short error;
    void * addr;

    error =
      EpcSetAmMap(  A16N |	/* map VXI A16 address space,  */
		    BM_MBO,	/* and swap bytes.  */
		    (unsigned long) suggested,	/* suggested address */
		    &addr 	/* returned address */
		  );
    if (error)
	return 0;
    else
	return addr;

#else

    ...your code goes here...

#endif

}

#endif    /* EMULATE_SICL */
